#include "Lives.h"



Lives::Lives(sf::RenderWindow* hwnd, Input* input) : Level(hwnd, input)
{
	backgroundTexture.loadFromFile("Assets/Sprites/Levels/Lives/background.png");	//Load the background texture and set it to the window size
	backgroundSprite.setTexture(&backgroundTexture);
	backgroundSprite.setSize(sf::Vector2f(1024, 768));
}


Lives::~Lives()
{
}

void Lives::displayLives(Mario* mario)
{
	setupTextObject(&livesText);	//Call setupTextObject to set the font, font size and colour
	livesText.setString(std::to_string(mario->getLives()));	//Call getLives to set the string of Mario's lives correctly
	livesText.setPosition(sf::Vector2f(590, 390));
}

void Lives::handleInput(float dt)
{

}

void Lives::update(float dt)
{
	if (Timer::setWaitTime(3.0, dt))	//After 3 seconds are up, we progress onto the main game
	{
		currentLevel = Level::QueryLevel(LevelType_MainGame);
	}
}

void Lives::render()
{
	window->draw(backgroundSprite);
	window->draw(livesText);
}